#pragma once
#include <time.h>
#include <math.h>
enum ScaleFactorCommand
{
    Reset,
    Increase,
    Decrease
};

class TimeManager
{
public:
    TimeManager(const float maxTimeInS);
    const float     GetTime() const { return m_scaledTime; }
    const float     GetDeltaTime() const { return m_scaleFactor * m_deltaTime; }
    const float     GetScaleFactor() const { return m_scaleFactor; }
    void            SetScaleFactor(const float factor) { m_scaleFactor = factor; }
    void            Tick(void)
    {
        clock_t curClock = clock();
        //delta time if wrongly calculated if m_previousClock == 0
        //m_deltaTime = float(curClock - m_previousClock) / CLOCKS_PER_SEC;
        
        m_deltaTime = m_previousClock == 0 ? 0.0f : float(curClock - m_previousClock) / CLOCKS_PER_SEC;
        m_previousClock = curClock;
        
        m_scaledTime = fmod(m_scaledTime + m_scaleFactor*m_deltaTime, m_maxTimeInS); // we loop when playing forward
        if(m_scaledTime <0) // but we pause when playing backward
        {
            m_scaledTime = 0;
            m_scaleFactor = 0;
        }
    }
    void ExecuteScaleCommand(const ScaleFactorCommand& cmd)
    {
        switch (cmd)
        {
        case ScaleFactorCommand::Reset : SetScaleFactor(1.0f);break;

        case ScaleFactorCommand::Decrease :
        case ScaleFactorCommand::Increase :
            {
                float delta = 1.0f;
                if(m_scaleFactor * m_scaleFactor <= 1.0f)
                { 
                    delta = 0.5f; 
                }
                
                if(cmd == ScaleFactorCommand::Decrease ) {
                    delta = - delta; 
                }

                float factorCandidat = m_scaleFactor + delta;
                if(factorCandidat * factorCandidat <= m_maxScaleFactorAbs * m_maxScaleFactorAbs)
                {
                    this->SetScaleFactor(factorCandidat);
                }
                break;
            }

        default:
            break;
        }
    }


    ~TimeManager(void);
private:
    clock_t m_previousClock;
    float   m_deltaTime;
    float   m_scaleFactor;
    float   m_maxScaleFactorAbs;

    float   m_scaledTime;
    float   m_maxTimeInS;
};

